/*
 * Decompiled with CFR 0.152.
 */
package com.feildmaster.chanchat.Util;

import com.feildmaster.chanchat.Chat;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.bukkit.ChatColor;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ModuleConfiguration
extends YamlConfiguration {
    private final JavaPlugin plugin;
    private final File file;
    private InputStream stream;

    public ModuleConfiguration(JavaPlugin p) {
        this(p, p.getDescription().getName() + ".yml");
    }

    public ModuleConfiguration(JavaPlugin p, String configName) {
        this.plugin = p;
        this.file = new File(Chat.getModuleFolder(), configName);
        this.load();
        this.loadDefaults(configName);
    }

    public final boolean load() {
        try {
            this.load(this.file);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean saveDefaults() {
        try {
            this.options().copyDefaults(true);
            this.save(this.file);
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.options().copyDefaults(false);
            return true;
        }
    }

    public final boolean save() {
        try {
            this.save(this.file);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public final boolean exists() {
        return this.file.exists();
    }

    public final void loadDefaults(String filename) {
        try {
            URL url = this.plugin.getClass().getClassLoader().getResource(filename);
            URLConnection con = url.openConnection();
            con.setUseCaches(false);
            this.stream = con.getInputStream();
        }
        catch (Exception ex) {
            this.stream = null;
        }
        if (this.stream != null) {
            this.setDefaults((Configuration)YamlConfiguration.loadConfiguration((InputStream)this.stream));
        }
    }

    public final ChatColor getChatColor(String path) {
        return ChatColor.WHITE;
    }
}

