/*
 * Decompiled with CFR 0.152.
 */
package com.feildmaster.chanchat.Util;

import com.feildmaster.chanchat.Chan.ChannelManager;
import com.feildmaster.chanchat.Chat;
import com.massivecraft.factions.Factions;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.plugin.PluginManager;
import org.bukkit.util.config.Configuration;

public final class ChatUtil {
    private static final Server server = Bukkit.getServer();
    public static final Logger log = ChatUtil.getServer().getLogger();
    private static Chat chatPlugin;
    private static Factions factionPlugin;
    private static PluginManager pm;

    public static Server getServer() {
        return server;
    }

    public static PluginManager getPluginManager() {
        if (pm == null) {
            pm = server.getPluginManager();
        }
        return pm;
    }

    public static Chat getChatPlugin() {
        if (chatPlugin == null) {
            chatPlugin = (Chat)ChatUtil.getPluginManager().getPlugin("ChannelChat");
            factionPlugin = (Factions)ChatUtil.getPluginManager().getPlugin("Factions");
        }
        return chatPlugin;
    }

    public static Factions getFactionPlugin() {
        return factionPlugin;
    }

    public static ChannelManager getCM() {
        return ChatUtil.getChatPlugin().getCM();
    }

    public static Configuration getDefaultConfig() {
        return ChatUtil.getChatPlugin().getConfiguration();
    }

    public static Player getPlayer(String name) {
        return ChatUtil.getServer().getPlayer(name);
    }

    public static void reload() {
        ChatUtil.getChatPlugin().getCC1().reload();
        ChatUtil.getChatPlugin().getCC2().reload(true);
    }

    public static void save() {
        ChatUtil.getChatPlugin().getCC1().save();
        ChatUtil.getChatPlugin().getCC2().save();
    }

    public static Logger log() {
        return ChatUtil.getServer().getLogger();
    }

    public static String error(String msg) {
        return ChatColor.RED + msg;
    }

    public static String info(String msg) {
        return ChatColor.YELLOW + msg;
    }

    public static String format(ChatColor color, String msg) {
        return String.format(color + "[%1$s] %2$s", ChatUtil.getChatPlugin().getDescription().getName(), msg);
    }
}

