/*
 * Decompiled with CFR 0.152.
 */
package com.feildmaster.chanchat.Util;

import com.feildmaster.chanchat.Chan.Channel;
import com.feildmaster.chanchat.Chan.LocalChannel;
import com.feildmaster.chanchat.Chat;
import com.feildmaster.chanchat.Util.ChatUtil;
import java.util.List;
import org.bukkit.util.config.Configuration;
import org.bukkit.util.config.ConfigurationNode;

public class ChanConfig {
    private final Configuration config;

    public ChanConfig(Configuration c) {
        this.config = c;
        this.config.load();
        if (this.config.getAll().isEmpty() && this.config.getHeader() == null) {
            this.createDefault();
        }
        this.setHeader();
        this.reload(false);
    }

    private void createDefault() {
        this.setHeader();
        this.config.setProperty("General.auto_join", (Object)true);
        this.config.setProperty("General.tag", (Object)"[G]");
        this.config.setProperty("General.listed", (Object)true);
        this.config.setProperty("General.alias", (Object)"g");
        this.config.setProperty("Local.type", (Object)"Local");
        this.config.setProperty("Local.tag", (Object)"[L]");
        this.config.setProperty("Local.alias", (Object)"l");
        this.config.setProperty("Local.range", (Object)1000);
        this.config.setProperty("World.type", (Object)"World");
        this.config.setProperty("World.tag", (Object)"[{World}]");
        this.config.setProperty("World.alias", (Object)"w");
        this.config.save();
    }

    public void save() {
        for (String key : this.config.getKeys()) {
            this.config.removeProperty(key);
        }
        for (Channel chan : ChatUtil.getCM().getChannels()) {
            if (chan.isSaved().booleanValue()) {
                this.config.setProperty(chan.getName() + ".type", (Object)chan.getType().name());
                this.config.setProperty(chan.getName() + ".tag", (Object)chan.getTag());
                this.config.setProperty(chan.getName() + ".owner", (Object)chan.getOwner());
                this.config.setProperty(chan.getName() + ".password", (Object)chan.getPass());
                this.config.setProperty(chan.getName() + ".listed", (Object)chan.isListed());
                this.config.setProperty(chan.getName() + ".auto_join", (Object)chan.isAuto());
                this.config.setProperty(chan.getName() + ".alias", (Object)chan.getAlias());
                if (chan.getType().equals((Object)Channel.Type.Local)) {
                    this.config.setProperty(chan.getName() + ".range", (Object)((LocalChannel)chan).getRange());
                    this.config.setProperty(chan.getName() + ".null_message", (Object)((LocalChannel)chan).getNullMessage());
                }
            }
            chan.callSave();
        }
        this.config.save();
    }

    public final void reload(boolean bool) {
        this.config.load();
        List keys = this.config.getKeys();
        for (Channel chan : ChatUtil.getCM().getSavedChannels()) {
            if (keys.contains(chan.getName())) continue;
            ChatUtil.getCM().delChannel(chan.getName());
        }
        for (String name : keys) {
            Channel chan;
            ConfigurationNode node = this.config.getNode(name);
            if (ChatUtil.getCM().channelExists(name).booleanValue()) {
                chan = ChatUtil.getCM().getChannel(name);
                if (node != null) {
                    Channel.Type type = Channel.Type.betterValueOf(node.getString("type"));
                    if (!chan.getType().equals((Object)type)) {
                        chan = ChatUtil.getCM().convertChannel(chan, type);
                    }
                }
            } else {
                chan = ChatUtil.getCM().createChannel(name, node == null ? Channel.Type.Global : Channel.Type.betterValueOf(node.getString("type")));
            }
            if (node != null) {
                chan.setTag(node.getString("tag"));
                chan.setOwner(node.getString("owner"));
                chan.setPass(node.getString("password"));
                chan.setListed(node.getBoolean("listed", false));
                chan.setAuto(node.getBoolean("auto_join", false));
                if (chan.getType() == Channel.Type.Local) {
                    ((LocalChannel)chan).setNullMessage(node.getString("null_message"));
                    ((LocalChannel)chan).setRange(node.getInt("range", 1000));
                }
            }
            ChatUtil.getCM().addChannel(chan);
        }
        if (bool) {
            for (Channel chan : Chat.getChannelManager().getChannels()) {
                if (!chan.getType().equals((Object)Channel.Type.Custom)) continue;
                chan.callReload();
            }
        }
    }

    private void setHeader() {
        this.config.setHeader(new String[]{"#ChannelName: #No spaces in name", "#    auto_join: #true/false", "#    listed: #true/false", "#    owner: #Owner Name", "#    range: #For Local Channels", "#    tag: #Channel Tag", "#    type: #Global/Local/World", "#    password: #Channel Password", "#    shortcut: #Not yet. ;)"});
    }
}

