/*
 * Decompiled with CFR 0.152.
 */
package com.feildmaster.chanchat.Commands;

import com.feildmaster.chanchat.Chan.Channel;
import com.feildmaster.chanchat.Chan.ChannelManager;
import com.feildmaster.chanchat.Commands.ChatInterface;
import com.feildmaster.chanchat.Util.ChatUtil;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class BaseCommands
implements ChatInterface {
    private final ChannelManager cm = ChatUtil.getCM();

    protected void listChannels(Player player, Boolean mem) {
        StringBuilder string = new StringBuilder();
        boolean color = true;
        for (Channel chan : this.cm.getChannels()) {
            if (!chan.isListed().booleanValue()) continue;
            color = !color;
            string.append(string.length() != 0 ? ", " : "").append(color ? ChatColor.GRAY : ChatColor.WHITE).append(chan.isMember(player) != false ? "*" : "").append(chan.getName());
        }
        player.sendMessage("Channels: " + string.toString());
    }

    protected void quickChat(String name, Player player, String[] args) {
        Channel chan = this.cm.getChannel(name);
        if (chan == null) {
            player.sendMessage(this.info("Channel does not exist"));
        } else if (chan.isMember(player).booleanValue()) {
            StringBuilder str = new StringBuilder();
            for (int x = 1; x < args.length; ++x) {
                str.append(x != 1 ? " " : "").append(args[x]);
            }
            this.cm.sendMessage(player, chan, str.toString());
        } else {
            player.sendMessage(this.info("You are not a member of \"" + chan.getName() + ".\""));
        }
    }

    protected void getChannelMembers(String name, Player player) {
        Channel chan = this.cm.getChannel(name);
        if (this.cm.channelExists(name).booleanValue() && chan.isMember(player).booleanValue()) {
            StringBuilder string = new StringBuilder();
            boolean color = true;
            if (chan.getMembers(player).size() > 1) {
                for (String p : chan.getMembers(player)) {
                    color = !color;
                    string.append(string.length() != 0 ? ", " : "").append(color ? ChatColor.GRAY : ChatColor.WHITE).append(ChatColor.stripColor((String)ChatUtil.getPlayer(p).getDisplayName()));
                }
            } else {
                string.append(ChatColor.WHITE).append("Only you");
            }
            player.sendMessage(string.insert(0, ChatColor.GRAY + "Members: ").toString());
        } else {
            player.sendMessage(ChatColor.GRAY + "The channel doesn't exist!");
        }
    }

    protected void getChannelMembers(Player player) {
        this.getChannelMembers(this.cm.getActiveName(player), player);
    }

    protected void createChannel(String name, CommandSender sender) {
        if (this.cm.channelExists(name).booleanValue()) {
            sender.sendMessage("Channel Already Exists!");
            return;
        }
        if (this.cm.isReserved(name).booleanValue()) {
            sender.sendMessage("Channel Blacklisted.");
            return;
        }
        Channel chan = null;
        if (sender instanceof Player) {
            if (!((Player)sender).hasPermission("ChanChat.create")) {
                sender.sendMessage("You can't do that.");
                return;
            }
            chan = this.cm.createChannel(name, Channel.Type.Private);
            Player player = (Player)sender;
            chan.setOwner(player);
            chan.addMember(player);
            if (this.cm.getActiveName(player) == null) {
                this.cm.setActiveChan(player, chan.getName());
            }
            this.cm.addChannel(chan);
        } else {
            chan = this.cm.createChannel(name, Channel.Type.Global);
            this.cm.addChannel(chan);
        }
        chan.sendMessage(" Created");
    }

    protected void deleteActiveChannel(Player player) {
        this.deleteChannel(this.cm.getActiveName(player), (CommandSender)player);
    }

    protected void deleteChannel(String name, CommandSender sender) {
        if (this.cm.channelExists(name).booleanValue()) {
            Channel chan = this.cm.getChannel(name);
            if (sender instanceof Player) {
                if (chan.isOwner((Player)sender).booleanValue() || sender.hasPermission("ChanChat.admin")) {
                    this.cm.delChannel(name);
                } else {
                    sender.sendMessage("You can't do that.");
                }
            } else {
                this.cm.delChannel(name);
            }
        } else {
            sender.sendMessage("The channel doesn't exists!");
        }
    }

    protected void joinChannel(String name, Player player) {
        if (this.cm.channelExists(name).booleanValue()) {
            Channel chan = this.cm.getChannel(name);
            if (chan.isMember(player).booleanValue()) {
                player.sendMessage(ChatColor.GRAY + "You are already in \"" + chan.getName() + ".\"");
            } else if (chan.getPass() != null) {
                player.sendMessage(ChatColor.GRAY + "[" + chan.getName() + "] Please enter the password");
                this.cm.addToWaitlist(player, name);
            } else {
                chan.addMember(player, true);
            }
        } else {
            this.createChannel(name, (CommandSender)player);
        }
    }

    protected void leaveChannel(String name, Player player) {
        if (name.equalsIgnoreCase("all")) {
            this.leaveAll(player);
        } else if (this.cm.channelExists(name).booleanValue()) {
            this.leaveChannel(player, this.cm.getChannel(name));
        } else {
            player.sendMessage(this.error("Channel \"" + name + "\" doesn't exist."));
        }
    }

    protected void leaveActiveChannel(Player player) {
        Channel chan = this.cm.getActiveChan(player);
        if (chan != null) {
            this.leaveChannel(player, chan);
        } else {
            player.sendMessage("You are not in any channels to leave!");
        }
    }

    private void leaveChannel(Player player, Channel chan) {
        chan.delMember(player, true);
    }

    private void leaveAll(Player player) {
        for (Channel c : this.cm.getJoinedChannels(player)) {
            c.delMember(player);
        }
        player.sendMessage(this.info("You have left all channels."));
    }

    protected void addPlayer(Player player, String i) {
        Player added = ChatUtil.getPlayer(i);
        if (added == null) {
            player.sendMessage(this.error("Player [" + i + "] not found"));
            return;
        }
        Channel chan = this.cm.getActiveChan(player);
        if (chan == null) {
            player.sendMessage(this.error("Active channel not set, or you have not joined a channel."));
        } else if (chan.isMember(player).booleanValue() && !chan.isMember(added).booleanValue()) {
            chan.sendMessage(this.info(ChatColor.stripColor((String)added.getDisplayName()) + " has been added by " + ChatColor.stripColor((String)player.getDisplayName())));
            chan.addMember(added);
            added.sendMessage(this.info("You have been added to \"" + chan.getName() + ".\""));
        } else if (chan.isMember(player).booleanValue() && chan.isMember(added).booleanValue()) {
            player.sendMessage(this.info("Player is already in channel \"" + chan.getName() + ".\""));
        }
    }

    protected void setChannel(String name, Player player) {
        if (this.cm.channelExists(name).booleanValue()) {
            Channel chan = this.cm.getChannel(name);
            if (chan.isMember(player).booleanValue()) {
                this.cm.setActiveByChan(player, chan);
                player.sendMessage(this.info("Now talking in \"" + chan.getName() + ".\""));
            } else {
                player.sendMessage(this.info("You are not in \"" + chan.getName() + ".\""));
            }
        } else {
            player.sendMessage(this.error("Channel \"" + name + "\" doesn't exist."));
        }
    }

    protected Boolean reload(CommandSender sender) {
        if (this.isPlayer(sender).booleanValue()) {
            Player p = (Player)sender;
            if (p.hasPermission("ChanChat.reload")) {
                ChatUtil.reload();
                p.sendMessage("[CC] Reloaded");
            }
        } else {
            ChatUtil.reload();
            sender.sendMessage("[CC] Reloaded");
        }
        return true;
    }

    protected void replyActive(Player player) {
        player.sendMessage("Active Channel: " + this.cm.getActiveName(player));
    }

    protected Boolean isReserved(String name) {
        return this.cm.isReserved(name);
    }

    protected Boolean channelExists(String name) {
        return this.cm.channelExists(name);
    }

    protected Boolean isPlayer(CommandSender sender) {
        return sender instanceof Player;
    }

    protected Channel getChannel(String name) {
        return this.cm.getChannel(name);
    }

    public String error(String msg) {
        return ChatColor.RED + msg;
    }

    public String info(String msg) {
        return ChatColor.YELLOW + msg;
    }
}

