/*
 * Decompiled with CFR 0.152.
 */
package com.feildmaster.chanchat;

import com.feildmaster.chanchat.Chan.Channel;
import com.feildmaster.chanchat.Chan.ChannelManager;
import com.feildmaster.chanchat.Commands.AddCommand;
import com.feildmaster.chanchat.Commands.AdminCommand;
import com.feildmaster.chanchat.Commands.ChatCommand;
import com.feildmaster.chanchat.Commands.CreateCommand;
import com.feildmaster.chanchat.Commands.DeleteCommand;
import com.feildmaster.chanchat.Commands.JoinCommand;
import com.feildmaster.chanchat.Commands.LeaveCommand;
import com.feildmaster.chanchat.Commands.SetCommand;
import com.feildmaster.chanchat.Listeners.ChatListener;
import com.feildmaster.chanchat.Listeners.EarlyChatListener;
import com.feildmaster.chanchat.Listeners.LogInOut;
import com.feildmaster.chanchat.Util.ChanConfig;
import com.feildmaster.chanchat.Util.ChatConfig;
import com.feildmaster.chanchat.Util.ChatUtil;
import java.io.File;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.config.Configuration;

public class Chat
extends JavaPlugin {
    private static final ChannelManager cm = new ChannelManager();
    private static File module_folder = new File("plugins/ChannelChat/modules");
    private ChatConfig config;
    private ChanConfig cConfig;

    public void onDisable() {
        ChatUtil.save();
        ChatUtil.log.info(this.getDescription().getName() + " v" + this.getDescription().getVersion() + " disabled");
    }

    public void onEnable() {
        PluginManager pm = this.getServer().getPluginManager();
        LogInOut loginout = new LogInOut();
        pm.registerEvent(Event.Type.PLAYER_JOIN, (Listener)loginout, Event.Priority.Monitor, (Plugin)this);
        pm.registerEvent(Event.Type.PLAYER_QUIT, (Listener)loginout, Event.Priority.Monitor, (Plugin)this);
        pm.registerEvent(Event.Type.PLAYER_KICK, (Listener)loginout, Event.Priority.Monitor, (Plugin)this);
        pm.registerEvent(Event.Type.PLAYER_CHAT, (Listener)new ChatListener(), Event.Priority.Highest, (Plugin)this);
        pm.registerEvent(Event.Type.PLAYER_CHAT, (Listener)new EarlyChatListener(), Event.Priority.Lowest, (Plugin)this);
        this.config = new ChatConfig(new File(this.getDataFolder(), "config.yml"));
        this.cConfig = new ChanConfig(new Configuration(new File(this.getDataFolder(), "channels.yml")));
        this.getCommand("channel-admin").setExecutor((CommandExecutor)new AdminCommand());
        this.getCommand("channel-chat").setExecutor((CommandExecutor)new ChatCommand());
        this.getCommand("channel-join").setExecutor((CommandExecutor)new JoinCommand());
        this.getCommand("channel-leave").setExecutor((CommandExecutor)new LeaveCommand());
        this.getCommand("channel-create").setExecutor((CommandExecutor)new CreateCommand());
        this.getCommand("channel-delete").setExecutor((CommandExecutor)new DeleteCommand());
        this.getCommand("channel-add").setExecutor((CommandExecutor)new AddCommand());
        this.getCommand("channel-set").setExecutor((CommandExecutor)new SetCommand());
        for (Player player : this.getServer().getOnlinePlayers()) {
            for (Channel chan : cm.getAutoChannels()) {
                chan.addMember(player);
            }
        }
        ChatUtil.log.info(this.getDescription().getName() + " v" + this.getDescription().getVersion() + " enabled");
    }

    public static File getModuleFolder() {
        return module_folder;
    }

    public ChannelManager getCM() {
        return cm;
    }

    public static ChannelManager getChannelManager() {
        return cm;
    }

    public ChatConfig getCC1() {
        return this.config;
    }

    public ChanConfig getCC2() {
        return this.cConfig;
    }
}

