/*
 * Decompiled with CFR 0.152.
 */
package com.feildmaster.chanchat.Chan;

import com.feildmaster.chanchat.Chan.Channel;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerChatEvent;

public final class WorldChannel
extends Channel {
    private World world = null;

    protected WorldChannel(String name) {
        super(name, Channel.Type.World);
    }

    protected WorldChannel(Channel chan) {
        super(chan, Channel.Type.World);
    }

    @Override
    public String getDisplayName() {
        if (this.getTag() == null) {
            return "[" + this.getName() + "]";
        }
        return super.getDisplayName().replaceAll("(?i)\\{world}", this.world == null ? "" : this.world.getName());
    }

    @Override
    public void sendJoinMessage(Player player) {
        this.world = player.getWorld();
        super.sendJoinMessage(player);
        this.world = null;
    }

    @Override
    public Boolean isMember(Player player) {
        if (this.world == null) {
            return super.isMember(player);
        }
        return super.isMember(player) != false && this.world.equals(player.getWorld());
    }

    @Override
    public void handleEvent(PlayerChatEvent event) {
        this.world = event.getPlayer().getWorld();
        super.handleEvent(event);
        this.world = null;
    }
}

