/*
 * Decompiled with CFR 0.152.
 */
package com.feildmaster.chanchat.Chan;

import com.feildmaster.chanchat.Chan.Channel;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerChatEvent;

public final class LocalChannel
extends Channel {
    private int range = 1000;
    private int range_squared = 1000000;
    private String out_of_range = "No one within range of your voice...";
    private Location location;

    protected LocalChannel(String name) {
        super(name, Channel.Type.Local);
    }

    protected LocalChannel(Channel chan) {
        super(chan, Channel.Type.Local);
    }

    public Channel setRange(int r) {
        if (this.range == r) {
            return this;
        }
        this.range = r;
        this.range_squared = (int)Math.pow(r, 2.0);
        return this;
    }

    public int getRange() {
        return this.range;
    }

    public Boolean outOfRange(Location l) {
        if (!this.location.getWorld().equals(l.getWorld())) {
            return true;
        }
        if (this.location.equals((Object)l)) {
            return false;
        }
        if (this.location.distanceSquared(l) > (double)this.range_squared) {
            return true;
        }
        return false;
    }

    public void setNullMessage(String string) {
        this.out_of_range = string;
    }

    public String getNullMessage() {
        return this.out_of_range;
    }

    @Override
    public Boolean isMember(Player player) {
        if (super.isMember(player).booleanValue() && this.location == null) {
            return true;
        }
        if (this.location == null) {
            return false;
        }
        return super.isMember(player) != false && this.outOfRange(player.getLocation()) == false;
    }

    @Override
    public void handleEvent(PlayerChatEvent event) {
        this.location = event.getPlayer().getLocation();
        super.handleEvent(event);
        if (event.getRecipients().size() == 1 && this.getNullMessage() != null) {
            event.getPlayer().sendMessage(this.getNullMessage());
            event.setCancelled(true);
        }
        this.location = null;
    }
}

