/*
 * Decompiled with CFR 0.152.
 */
package com.feildmaster.chanchat.Chan;

import com.feildmaster.chanchat.Chan.Channel;
import com.feildmaster.chanchat.Chan.LocalChannel;
import com.feildmaster.chanchat.Chan.WorldChannel;
import com.feildmaster.chanchat.Events.ChannelPlayerChatEvent;
import com.feildmaster.chanchat.Util.ChatUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public final class ChannelManager {
    private Map<Player, String> waitList = new HashMap<Player, String>();
    private List<Channel> registry = new ArrayList<Channel>();
    private Map<String, String> activeChannel = new HashMap<String, String>();
    private int ownerLimit = -1;

    public void deleteFromWaitlist(Player player) {
        this.waitList.remove(player);
    }

    public void addToWaitlist(Player player, String chan) {
        this.waitList.put(player, chan);
    }

    public Boolean inWaitlist(Player player) {
        return this.waitList.containsKey(player);
    }

    public Channel getWaitingChan(Player player) {
        return this.getChannel(this.waitList.get(player));
    }

    public Boolean isReserved(String n) {
        return n.matches("(?i)(active|add|admin|all|create|delete|join|leave|list|reload|who|\\?)");
    }

    public void sendMessage(String channel, String msg) {
        this.sendMessage(this.getChannel(channel), msg);
    }

    public void sendMessage(Channel channel, String msg) {
        if (channel == null || msg == null) {
            return;
        }
        channel.sendMessage(msg);
    }

    public void sendMessage(Player sender, String msg) {
        this.sendMessage(sender, this.getActiveChan(sender), msg);
    }

    public void sendMessage(Player sender, String channel, String msg) {
        this.sendMessage(sender, this.getChannel(channel), msg);
    }

    public void sendMessage(Player sender, Channel channel, String msg) {
        if (channel == null || sender == null || msg == null) {
            sender.sendMessage(ChatUtil.error("Missing info while trying to send message"));
            return;
        }
        ChannelPlayerChatEvent event = new ChannelPlayerChatEvent(sender, channel, msg);
        ChatUtil.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        msg = String.format(event.getFormat(), event.getPlayer().getDisplayName(), event.getMessage());
        System.out.println(msg.replaceAll("\u00a7.", ""));
        for (Player p : event.getRecipients()) {
            p.sendMessage(msg);
        }
    }

    public Channel getChannel(String name) {
        if (name == null) {
            return null;
        }
        for (Channel chan : this.getChannels()) {
            if (!chan.getName().equalsIgnoreCase(name) && (chan.getAlias() == null || !chan.getAlias().equalsIgnoreCase(name))) continue;
            return chan;
        }
        return null;
    }

    public Boolean channelExists(String name) {
        if (name == null) {
            return false;
        }
        for (Channel chan : this.getChannels()) {
            if (!chan.getName().equalsIgnoreCase(name) && (chan.getAlias() == null || !chan.getAlias().equalsIgnoreCase(name))) continue;
            return true;
        }
        return false;
    }

    public void addChannel(Channel chan) {
        if (this.channelExists(chan.getName()).booleanValue()) {
            return;
        }
        this.registry.add(chan);
    }

    public void delChannel(String name) {
        if (this.channelExists(name).booleanValue()) {
            Channel chan = this.getChannel(name);
            this.sendMessage(chan, " Has been deleted");
            this.registry.remove(chan);
            this.checkActive();
        }
    }

    public Channel createChannel(String name, Channel.Type type) {
        Channel chan = type == Channel.Type.Local ? new LocalChannel(name) : (type == Channel.Type.World ? new WorldChannel(name) : (type == Channel.Type.Private ? new Channel(name, Channel.Type.Private) : new Channel(name, Channel.Type.Global)));
        return chan;
    }

    public Channel convertChannel(Channel chan, Channel.Type type) {
        if (chan.getType().equals((Object)type) || chan.getType().equals((Object)Channel.Type.Custom) || type.equals((Object)Channel.Type.Custom)) {
            return chan;
        }
        Channel chan1 = type == Channel.Type.Local ? new LocalChannel(chan) : (type == Channel.Type.World ? new WorldChannel(chan) : (type == Channel.Type.Private ? new Channel(chan, Channel.Type.Private) : new Channel(chan, Channel.Type.Global)));
        if (this.registry.contains(chan)) {
            this.registry.remove(chan);
            this.registry.add(chan1);
        }
        return chan1;
    }

    public String getActiveName(Player player) {
        return this.activeChannel.get(player.getName());
    }

    public Channel getActiveChan(Player player) {
        return this.getChannel(this.getActiveName(player));
    }

    public void setActiveChan(Player player, String channel) {
        if (channel != null) {
            if (this.channelExists(channel).booleanValue() && this.getChannel(channel).isMember(player).booleanValue()) {
                this.activeChannel.put(player.getName(), channel);
            }
        } else {
            this.activeChannel.remove(player.getName());
        }
    }

    public void setActiveByChan(Player player, Channel chan) {
        this.setActiveChan(player, chan.getName());
    }

    public void checkActive() {
        if (!this.activeChannel.isEmpty()) {
            for (String name : this.activeChannel.keySet()) {
                this.checkActive(ChatUtil.getPlayer(name));
            }
        }
    }

    public void checkActive(Player player) {
        if (player == null) {
            return;
        }
        String channel = this.getActiveName(player);
        List<Channel> joinedChannels = this.getJoinedChannels(player);
        if (channel == null && joinedChannels.isEmpty() || this.channelExists(channel).booleanValue() && this.getChannel(channel).isMember(player).booleanValue()) {
            return;
        }
        if (channel != null && joinedChannels.isEmpty()) {
            this.setActiveChan(player, null);
        } else if (channel == null && !joinedChannels.isEmpty()) {
            this.setActiveChan(player, joinedChannels.get(0).getName());
        } else if (channel != null && this.channelExists(channel).booleanValue() && !this.getChannel(channel).isMember(player).booleanValue()) {
            String nChan = joinedChannels.get(0).getName();
            this.setActiveChan(player, nChan);
            player.sendMessage(ChatUtil.info("You are now in channel \"" + nChan + ".\""));
        }
    }

    public List<Channel> getJoinedChannels(Player player) {
        ArrayList<Channel> list = new ArrayList<Channel>();
        for (Channel chan : this.getChannels()) {
            if (!chan.isMember(player).booleanValue()) continue;
            list.add(chan);
        }
        return list;
    }

    public List<Channel> getChannels() {
        return new ArrayList<Channel>(this.registry);
    }

    public List<Channel> getAutoChannels() {
        ArrayList<Channel> list = new ArrayList<Channel>();
        for (Channel chan : this.getChannels()) {
            if (!chan.isAuto().booleanValue()) continue;
            list.add(chan);
        }
        return list;
    }

    public List<Channel> getSavedChannels() {
        ArrayList<Channel> list = new ArrayList<Channel>();
        for (Channel chan : this.getChannels()) {
            if (!chan.isSaved().booleanValue()) continue;
            list.add(chan);
        }
        return list;
    }
}

