/*
 * Decompiled with CFR 0.152.
 */
package com.feildmaster.chanchat.Chan;

import com.feildmaster.chanchat.Util.ChatUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerChatEvent;

public class Channel {
    private final String name;
    private final Type type;
    private String alias = null;
    private String tag = null;
    private String owner = null;
    private String pass = null;
    private Boolean auto_join = false;
    private Boolean listed = false;
    private Set<String> members = new HashSet<String>();
    private Boolean readOnly = false;
    private ChatColor fontColor = ChatColor.WHITE;
    private String permission = "";

    protected Channel(Channel c, Type t) {
        this.name = c.name;
        this.type = t;
        this.tag = c.tag;
        this.owner = c.owner;
        this.pass = c.pass;
        this.auto_join = c.auto_join;
        this.listed = c.listed;
        this.members = c.members;
    }

    protected Channel(String n, Type t) {
        this.name = n;
        this.type = t;
    }

    public final void sendMessage(String msg) {
        if (this.members.isEmpty()) {
            return;
        }
        msg = this.format(msg);
        System.out.print(msg.replaceAll("\u00a7.", ""));
        for (String n : this.members) {
            Player p = ChatUtil.getPlayer(n);
            if (!this.isMember(p).booleanValue()) continue;
            p.sendMessage(msg);
        }
    }

    public void sendJoinMessage(Player player) {
        this.sendMessage(" " + ChatColor.YELLOW + ChatColor.stripColor((String)player.getDisplayName()) + " has joined.");
    }

    public void sendLeaveMessage(Player player) {
        this.sendMessage(" " + ChatColor.YELLOW + ChatColor.stripColor((String)player.getDisplayName()) + " has left.");
    }

    public final String format(String old) {
        return this.getDisplayName() + (old.equals("<%1$s> %2$s") ? " " : "") + old;
    }

    public String getDisplayName() {
        return this.tag == null ? "[" + this.name + "]" : this.tag.replaceAll("(?i)`(?=[0-9A-F])", "\u00a7") + ChatColor.WHITE;
    }

    public final String getName() {
        return this.name;
    }

    public final Type getType() {
        return this.type;
    }

    public final String getAlias() {
        return this.alias;
    }

    public final boolean setAlias(String s) {
        if (this.alias == s) {
            return true;
        }
        if (s != null && ChatUtil.getCM().getChannel(s) != null) {
            return false;
        }
        this.alias = s;
        return true;
    }

    public final void setTag(String t) {
        this.tag = t;
    }

    public final String getTag() {
        return this.tag;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(Player player) {
        this.setOwner(player.getName());
    }

    public void setOwner(String name) {
        this.owner = name;
    }

    public final Boolean isOwner(Player player) {
        if (this.owner == null || this.owner.isEmpty()) {
            return false;
        }
        return this.owner.equalsIgnoreCase(player.getName());
    }

    public Set<String> getMembers(Player player) {
        return new HashSet<String>(this.members);
    }

    public Boolean isSenderMember(Player player) {
        return this.isMember(player);
    }

    public Boolean isMember(Player player) {
        if (player == null) {
            return false;
        }
        return this.isMember(player.getName());
    }

    private Boolean isMember(String player) {
        return this.members.contains(player);
    }

    public final void addMember(Player player) {
        this.addMember(player, false);
    }

    public final void addMember(Player player, Boolean alert) {
        if (player == null) {
            return;
        }
        this.addMember(player.getName());
        if (alert.booleanValue()) {
            this.sendJoinMessage(player);
        }
    }

    private void addMember(String player) {
        if (player == null) {
            return;
        }
        this.members.add(player);
    }

    public final void delMember(Player player) {
        this.delMember(player, false);
    }

    public final void delMember(Player player, Boolean alert) {
        if (player == null || !this.isMember(player).booleanValue()) {
            return;
        }
        if (alert.booleanValue()) {
            this.sendLeaveMessage(player);
        }
        this.delMember(player.getName());
    }

    private void delMember(String player) {
        this.members.remove(player);
    }

    public final void removePass() {
        this.setPass(null);
    }

    public final String getPass() {
        return this.pass;
    }

    public final void setPass(String p) {
        this.pass = p;
    }

    public final void setListed(Boolean l) {
        this.listed = l;
    }

    public final Boolean isListed() {
        return this.listed;
    }

    public final void setAuto(Boolean v) {
        this.auto_join = v;
    }

    public final Boolean isAuto() {
        return this.auto_join;
    }

    public void handleEvent(PlayerChatEvent event) {
        if (this.isSenderMember(event.getPlayer()).booleanValue()) {
            for (Player p : new HashSet(event.getRecipients())) {
                if (this.isMember(p).booleanValue()) continue;
                event.getRecipients().remove(p);
            }
            event.setFormat(this.format(event.getFormat()));
        } else {
            event.getPlayer().sendMessage(this.format(" Not a member"));
            event.setCancelled(true);
        }
    }

    public void callSave() {
    }

    public void callReload() {
    }

    public final Boolean isSaved() {
        return !this.type.equals((Object)Type.Private) && !this.type.equals((Object)Type.Custom);
    }

    public final void setChatColor(ChatColor color) {
        this.fontColor = color;
    }

    public final ChatColor getChatColor() {
        return this.fontColor;
    }

    public static enum Type {
        Global,
        World,
        Local,
        Private,
        Custom;

        static final List<String> list;

        public static boolean contains(String name) {
            return list.contains(name);
        }

        public static Type betterValueOf(String name) {
            if (name != null) {
                for (Type t : Type.values()) {
                    if (!t.name().equals(name)) continue;
                    return t;
                }
            }
            return Global;
        }

        static {
            list = new ArrayList<String>();
            for (Type t : Type.values()) {
                list.add(t.name());
            }
        }
    }
}

