/*
 * Decompiled with CFR 0.152.
 */
package com.wimbli.TexturePackMenu;

import com.wimbli.TexturePackMenu.Config;
import com.wimbli.TexturePackMenu.TexturePackMenu;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.getspout.spoutapi.SpoutManager;
import org.getspout.spoutapi.event.screen.ButtonClickEvent;
import org.getspout.spoutapi.gui.Color;
import org.getspout.spoutapi.gui.GenericButton;
import org.getspout.spoutapi.gui.GenericLabel;
import org.getspout.spoutapi.gui.GenericPopup;
import org.getspout.spoutapi.gui.PopupScreen;
import org.getspout.spoutapi.gui.Widget;
import org.getspout.spoutapi.player.SpoutPlayer;

public class TPMPopup
extends GenericPopup {
    private TexturePackMenu tmpPlugin;
    private SpoutPlayer sPlayer;
    private GenericButton bNext;
    private GenericButton bPrev;
    private ArrayList<GenericButton> bChoice = new ArrayList(10);
    private String[] packNames = new String[0];
    private int page = 0;
    private int maxPage = 0;

    public static void create(TexturePackMenu plugin, Player player) {
        if (!player.hasPermission("texturepackmenu.texture")) {
            player.sendMessage("You do not have the necessary permission to choose a texture pack.");
            return;
        }
        TPMPopup newPopup = new TPMPopup(plugin, player);
        newPopup.initiate();
    }

    public TPMPopup(TexturePackMenu mainPlugin, Player player) {
        if (player == null) {
            return;
        }
        this.sPlayer = SpoutManager.getPlayer((Player)player);
        if (this.sPlayer == null) {
            return;
        }
        this.tmpPlugin = mainPlugin;
        if (Config.texturePackCount() == 0) {
            player.sendMessage("Sorry, but no texture packs are currently configured.");
            return;
        }
        if (!this.sPlayer.isSpoutCraftEnabled()) {
            player.sendMessage("This only works with the Spoutcraft client. See here:");
            player.sendMessage("              " + ChatColor.BLUE + "http://bit.ly/spoutclient");
            return;
        }
        this.packNames = Config.texPackNames();
        this.maxPage = (int)Math.ceil((double)this.packNames.length / 10.0) - 1;
    }

    public void initiate() {
        this.initLabels();
        this.initOtherButtons();
        this.initChoiceButtons();
        this.refreshButtons();
        this.sPlayer.getMainScreen().attachPopupScreen((PopupScreen)this);
    }

    public void exit() {
        this.sPlayer.getMainScreen().closePopup();
    }

    private void makeChoice(int buttonIndex) {
        Config.setPackDelayed(this.sPlayer, this.page * 10 + buttonIndex);
        this.exit();
    }

    private void refreshButtons() {
        int index;
        int loop;
        this.bPrev.setEnabled(this.page > 0);
        this.bNext.setEnabled(this.page < this.maxPage);
        this.bPrev.setDirty(true);
        this.bNext.setDirty(true);
        int offset = this.page * 10;
        for (loop = 0; loop < 10 && (index = offset + loop) <= this.packNames.length - 1; ++loop) {
            String text = this.packNames[index];
            GenericButton btn = this.bChoice.get(loop);
            btn.setTextColor(new Color(255, 255, 255, 0));
            if (index == 0) {
                text = "* " + text;
                btn.setTextColor(new Color(127, 255, 255, 0));
            }
            if (Config.getPack(this.sPlayer.getName()).equals(this.packNames[index])) {
                text = "@ " + text;
                btn.setTextColor(new Color(191, 255, 191, 0));
            }
            btn.setText(text);
            btn.setVisible(true);
            btn.setDirty(true);
        }
        while (loop < 10) {
            this.bChoice.get(loop).setVisible(false);
            this.bChoice.get(loop).setDirty(true);
            ++loop;
        }
    }

    private void nextPage() {
        if (this.page < this.maxPage) {
            ++this.page;
        }
        this.refreshButtons();
    }

    private void lastPage() {
        if (this.page > 0) {
            --this.page;
        }
        this.refreshButtons();
    }

    private void initLabels() {
        GenericLabel label = new GenericLabel("Choose a texture pack below:");
        label.setWidth(1).setHeight(1);
        label.setTextColor(new Color(63, 255, 63, 0));
        label.setScale(2.0f);
        label.setX(64).setY(20);
        this.attachWidget((Plugin)this.tmpPlugin, (Widget)label);
        label = new GenericLabel("* - Default Pack");
        label.setWidth(1).setHeight(1);
        label.setX(207).setY(191);
        label.setTextColor(new Color(127, 255, 255, 0));
        this.attachWidget((Plugin)this.tmpPlugin, (Widget)label);
        label = new GenericLabel("@ - Current Pack");
        label.setWidth(1).setHeight(1);
        label.setX(204).setY(201);
        label.setTextColor(new Color(191, 255, 191, 0));
        this.attachWidget((Plugin)this.tmpPlugin, (Widget)label);
    }

    private void initOtherButtons() {
        GenericButton cancel = new GenericButton("Cancel"){

            public void onButtonClick(ButtonClickEvent event) {
                TPMPopup.this.exit();
            }
        };
        cancel.setWidth(95).setHeight(20);
        cancel.setX(311).setY(190);
        cancel.setTextColor(new Color(255, 191, 191, 0));
        this.attachWidget((Plugin)this.tmpPlugin, (Widget)cancel);
        this.bPrev = new GenericButton("< Prev Page"){

            public void onButtonClick(ButtonClickEvent event) {
                TPMPopup.this.lastPage();
            }
        };
        this.bPrev.setWidth(80).setHeight(20);
        this.bPrev.setX(21).setY(190);
        if (this.maxPage == 0) {
            this.bPrev.setVisible(false);
        }
        this.attachWidget((Plugin)this.tmpPlugin, (Widget)this.bPrev);
        this.bNext = new GenericButton("Next Page >"){

            public void onButtonClick(ButtonClickEvent event) {
                TPMPopup.this.nextPage();
            }
        };
        this.bNext.setWidth(80).setHeight(20);
        this.bNext.setX(105).setY(190);
        if (this.maxPage == 0) {
            this.bNext.setVisible(false);
        }
        this.attachWidget((Plugin)this.tmpPlugin, (Widget)this.bNext);
    }

    private void initChoiceButtons() {
        this.bChoice = new ArrayList(10);
        boolean rowToggle = true;
        int bWidth = 190;
        int bHeight = 20;
        int offsetLeft1 = 21;
        int offsetLeft2 = 216;
        int offsetTop = 50;
        for (int i = 0; i < 10; ++i) {
            final int idx = i;
            GenericButton current = new GenericButton(Integer.toString(i + 1)){
                int index;
                {
                    super(x0);
                    this.index = idx;
                }

                public void onButtonClick(ButtonClickEvent event) {
                    TPMPopup.this.makeChoice(this.index);
                }
            };
            current.setWidth(190).setHeight(20);
            current.setX(rowToggle ? 21 : 216).setY(offsetTop);
            this.bChoice.add(current);
            this.attachWidget((Plugin)this.tmpPlugin, (Widget)current);
            if (!(rowToggle ^= true)) continue;
            offsetTop += 25;
        }
    }
}

