/*
 * Decompiled with CFR 0.152.
 */
package performancetweaks.bin.org.jbls.mrchasez;

import net.minecraft.server.WorldServer;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import performancetweaks.bin.org.jbls.mrchasez.ConfigManager;
import performancetweaks.bin.org.jbls.mrchasez.PerformanceTweaks;
import performancetweaks.bin.org.jbls.mrchasez.Util;

public class MonsterLimiter {
    private PerformanceTweaks mPlugin;
    private int mMaxMonsters;

    public MonsterLimiter(PerformanceTweaks plugin) {
        this.mPlugin = plugin;
    }

    public void onEnable() {
        ConfigManager cfg = new ConfigManager(this.mPlugin, "MonsterLimiter.yml");
        if (!cfg.load()) {
            cfg.setProperty("enable", true);
            cfg.setProperty("maxmonsters", 2500);
            cfg.save("========================================================\r\nEnable: Should ChunkPersistance be enabled?\r\nmaxmonsters: Max amount of Mobs that can spawn on the server at any time. \r\n========================================================\r\n");
        }
        this.mMaxMonsters = cfg.getInt("maxmonsters", 2400);
        if (!cfg.getBoolean("enable", true)) {
            System.out.println("[PTweaks] Disabled Monster Limiter");
            return;
        }
        try {
            System.out.println(String.format("[PTweaks] Monster Limit set to %d", this.mMaxMonsters));
        }
        catch (Exception e) {
            System.out.println("[PTweaks] Monster Limiter Failed: " + e.toString());
        }
    }

    public void onCreatureSpawn(CreatureSpawnEvent event) {
        World world = event.getEntity().getLocation().getWorld();
        int cnt = world.getLivingEntities().size() - world.getPlayers().size();
        if (cnt >= this.mMaxMonsters) {
            CraftWorld cWorld = (CraftWorld)event.getLocation().getWorld();
            WorldServer mWorld = cWorld.getHandle();
            mWorld.allowAnimals = false;
            mWorld.allowMonsters = false;
        }
    }

    public void onEntityDeath(EntityDeathEvent event) {
        World world = event.getEntity().getLocation().getWorld();
        int cnt = world.getLivingEntities().size() - world.getPlayers().size();
        if (cnt >= Math.max(this.mMaxMonsters - 100, 0)) {
            CraftWorld cWorld = (CraftWorld)event.getEntity().getLocation().getWorld();
            WorldServer mWorld = cWorld.getHandle();
            mWorld.allowAnimals = true;
            mWorld.allowMonsters = true;
        }
    }

    public void onDisable() {
        for (World bworld : this.mPlugin.getServer().getWorlds()) {
            CraftWorld cWorld = (CraftWorld)bworld;
            WorldServer mWorld = cWorld.getHandle();
            mWorld.allowAnimals = true;
            mWorld.allowMonsters = true;
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage("Missing argument: /ptml <info/ea/em/ra/rm>");
            return true;
        }
        if (args[0].equalsIgnoreCase("info")) {
            sender.sendMessage(String.format("%sMonster Limiter Status:", new Object[]{Util.FixedColor.DarkGreen}));
            for (World world : this.mPlugin.getServer().getWorlds()) {
                WorldServer mWorld = ((CraftWorld)world).getHandle();
                int count = world.getLivingEntities().size() - world.getPlayers().size();
                sender.sendMessage(String.format("%sWorld: %s%s", new Object[]{Util.FixedColor.DarkGreen, Util.FixedColor.White, world.getName()}));
                sender.sendMessage(String.format("  %sAllow Animals: %s%s", new Object[]{Util.FixedColor.DarkGreen, mWorld.allowAnimals ? Util.FixedColor.Green : Util.FixedColor.DarkRed, mWorld.allowAnimals ? "True" : "False"}));
                sender.sendMessage(String.format("  %sAllow Mobs: %s%s", new Object[]{Util.FixedColor.DarkGreen, mWorld.allowMonsters ? Util.FixedColor.Green : Util.FixedColor.DarkRed, mWorld.allowMonsters ? "True" : "False"}));
                sender.sendMessage(String.format("  %sMax Mobs: %s%d/%d", new Object[]{Util.FixedColor.DarkGreen, count < this.mMaxMonsters ? Util.FixedColor.Green : Util.FixedColor.Red, count, this.mMaxMonsters}));
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("ra")) {
            for (World world : this.mPlugin.getServer().getWorlds()) {
                WorldServer mWorld = ((CraftWorld)world).getHandle();
                mWorld.allowAnimals = false;
                sender.sendMessage(String.format("%sRemoved Animals on World: %s%s", new Object[]{Util.FixedColor.DarkGreen, Util.FixedColor.White, world.getName()}));
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("rm")) {
            for (World world : this.mPlugin.getServer().getWorlds()) {
                WorldServer mWorld = ((CraftWorld)world).getHandle();
                mWorld.allowMonsters = false;
                sender.sendMessage(String.format("%sRemoved Monsters on World: %s%s", new Object[]{Util.FixedColor.DarkGreen, Util.FixedColor.White, world.getName()}));
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("ea")) {
            for (World world : this.mPlugin.getServer().getWorlds()) {
                WorldServer mWorld = ((CraftWorld)world).getHandle();
                mWorld.allowAnimals = true;
                sender.sendMessage(String.format("%sEnabled Animals on World: %s%s", new Object[]{Util.FixedColor.DarkGreen, Util.FixedColor.White, world.getName()}));
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("em")) {
            for (World world : this.mPlugin.getServer().getWorlds()) {
                WorldServer mWorld = ((CraftWorld)world).getHandle();
                mWorld.allowMonsters = true;
                sender.sendMessage(String.format("%sEnabled Mosnters on World: %s%s", new Object[]{Util.FixedColor.DarkGreen, Util.FixedColor.White, world.getName()}));
            }
            return true;
        }
        return false;
    }
}

