/*
 * Decompiled with CFR 0.152.
 */
package performancetweaks.bin.org.jbls.mrchasez;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import java.util.Set;
import performancetweaks.bin.org.jbls.mrchasez.PerformanceTweaks;

public class ConfigManager {
    private PerformanceTweaks mPlugin;
    private String mFilename;
    private Properties mProps;

    public ConfigManager(PerformanceTweaks plugin, String file) {
        this.mPlugin = plugin;
        this.mProps = new Properties();
        this.mFilename = file;
    }

    public boolean load() {
        try {
            this.mProps.load(new FileInputStream(new File(this.mPlugin.getDataFolder(), this.mFilename)));
            return true;
        }
        catch (Exception e) {
            if (!this.mPlugin.getDataFolder().exists()) {
                this.mPlugin.getDataFolder().mkdirs();
            }
            File mFile = new File(this.mPlugin.getDataFolder(), this.mFilename);
            try {
                if (!mFile.exists()) {
                    mFile.createNewFile();
                }
                this.mProps.load(new FileInputStream(new File(this.mPlugin.getDataFolder(), this.mFilename)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }

    public String getString(String property, String defaultVal) {
        return this.mProps.getProperty(property, defaultVal);
    }

    public int getInt(String property, int defaultVal) {
        try {
            return Integer.parseInt(this.getString(property, String.valueOf(defaultVal)));
        }
        catch (Exception e) {
            return defaultVal;
        }
    }

    public boolean getBoolean(String property, boolean defaultVal) {
        try {
            return Boolean.parseBoolean(this.getString(property, defaultVal ? "True" : "False"));
        }
        catch (Exception e) {
            return defaultVal;
        }
    }

    public void setProperty(String property, String value) {
        this.mProps.setProperty(property, value);
    }

    public void setProperty(String property, int value) {
        this.mProps.setProperty(property, String.valueOf(value));
    }

    public void setProperty(String property, boolean value) {
        this.mProps.setProperty(property, value ? "True" : "False");
    }

    public void save(String comments) {
        try {
            this.mProps.store(new FileOutputStream(new File(this.mPlugin.getDataFolder(), this.mFilename)), comments);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String[] getKeys() {
        Set<Object> keyS = this.mProps.keySet();
        String[] keys = new String[keyS.size()];
        int i = 0;
        for (Object key : keyS) {
            keys[i++] = (String)key;
        }
        return keys;
    }
}

