/*
 * Decompiled with CFR 0.152.
 */
package performancetweaks.bin.org.jbls.mrchasez;

import java.util.Date;
import java.util.Hashtable;
import java.util.Set;
import net.minecraft.server.ChunkProviderServer;
import net.minecraft.server.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.plugin.Plugin;
import performancetweaks.bin.org.jbls.mrchasez.ConfigManager;
import performancetweaks.bin.org.jbls.mrchasez.PerformanceTweaks;

public class ChunkPersistance
implements Runnable,
Listener {
    private PerformanceTweaks mPlugin;
    private boolean mRunning = false;
    private Thread mThread;
    private int mLifeTime = 200000;
    private int mPruneTime = 3000;
    private Hashtable<Chunk, Long> mChunks = new Hashtable();
    ConfigManager cfg = null;

    public ChunkPersistance(PerformanceTweaks plugin) {
        this.mPlugin = plugin;
        this.mThread = new Thread(this);
    }

    public void onEnable() {
        this.cfg = new ConfigManager(this.mPlugin, "ChunkPersistance.yml");
        if (!this.cfg.load()) {
            this.cfg.setProperty("enable", true);
            this.cfg.setProperty("lifetime", 200000);
            this.cfg.setProperty("prune", 3000);
            this.cfg.save("========================================================\r\nEnable: Should ChunkPersistance be enabled?\r\nlifetime: The minimum lifetime of chunks in milliseconds. \r\nprune: The number of milliseconds before each prune cycle. Lifetime should not be less then this.\r\n========================================================\r\n");
        }
        this.mLifeTime = this.cfg.getInt("lifetime", 200000);
        this.mPruneTime = this.cfg.getInt("prune", 3000);
        if (!this.cfg.getBoolean("enable", true)) {
            System.out.println("[Ptweaks] Disabled Chunk Persistance");
            return;
        }
        this.mPlugin.getServer().getPluginManager();
        System.out.println(String.format("[PTweaks] Chunk Life Time: %dms", this.mLifeTime));
        System.out.println(String.format("[PTweaks] Chunk Prune Time: %dms", this.mPruneTime));
        long time = new Date().getTime();
        for (World world : this.mPlugin.getServer().getWorlds()) {
            Chunk[] chunkArray = world.getLoadedChunks();
            int n = chunkArray.length;
            int n2 = 0;
            while (n2 < n) {
                Chunk chunk = chunkArray[n2];
                if (!this.isSpawnChunk(chunk)) {
                    this.mChunks.put(chunk, time);
                }
                ++n2;
            }
        }
        this.mRunning = true;
        this.mThread.start();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.mPlugin);
    }

    public void onDisable() {
        if (this.mThread.isAlive()) {
            this.mThread.interrupt();
        }
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        if (!this.isSpawnChunk(event.getChunk())) {
            this.mChunks.put(event.getChunk(), new Date().getTime());
        }
    }

    @EventHandler
    public void onChunkUnload(ChunkUnloadEvent event) {
        long age;
        if (this.isSpawnChunk(event.getChunk())) {
            event.setCancelled(true);
            return;
        }
        if (!this.mChunks.containsKey(event.getChunk())) {
            this.mChunks.put(event.getChunk(), new Date().getTime());
        }
        if ((age = new Date().getTime() - this.mChunks.get(event.getChunk())) < (long)this.mLifeTime) {
            event.setCancelled(true);
        } else {
            this.mChunks.remove(event.getChunk());
        }
    }

    private boolean isSpawnChunk(Chunk chunk) {
        Location spawn = chunk.getWorld().getSpawnLocation();
        int x = chunk.getX() * 16 + 8 - spawn.getBlockX();
        int z = chunk.getZ() * 16 + 8 - spawn.getBlockZ();
        return x > -128 && x < 128 && z > -128 && z < 128;
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        long time = new Date().getTime();
        int x = event.getPlayer().getLocation().getBlockX() / 16 - 10;
        int z = event.getPlayer().getLocation().getBlockZ() / 16 - 10;
        World world = event.getPlayer().getLocation().getWorld();
        int a = 0;
        while (a < 20) {
            int b = 0;
            while (b < 20) {
                Chunk chunk = world.getChunkAt(x + a, z + b);
                if (!this.isSpawnChunk(chunk)) {
                    this.mChunks.put(chunk, time);
                }
                ++b;
            }
            ++a;
        }
    }

    @Override
    public void run() {
        try {
            while (this.mRunning && !this.mThread.isInterrupted()) {
                Thread.sleep(this.mPruneTime);
                Set<Chunk> keysS = this.mChunks.keySet();
                Chunk[] keys = new Chunk[keysS.size()];
                keysS.toArray(keys);
                long lNow = new Date().getTime();
                Chunk[] chunkArray = keys;
                int n = keys.length;
                int n2 = 0;
                while (n2 < n) {
                    Chunk key = chunkArray[n2];
                    long age = lNow - this.mChunks.get(key);
                    if (age >= (long)this.mLifeTime) {
                        CraftWorld cWorld = (CraftWorld)key.getWorld();
                        WorldServer mWorld = cWorld.getHandle();
                        ChunkProviderServer cp = (ChunkProviderServer)mWorld.chunkProvider;
                        if (!cp.unloadQueue.containsKey(key.getX(), key.getZ())) {
                            cp.queueUnload(key.getX(), key.getZ());
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

